/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class TCONString
extends TextEncodedStringSizeTerminated {
    private boolean isNullSeperateMultipleValues = true;

    public TCONString(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TCONString(TCONString object) {
        super(object);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof TCONString && super.equals(obj);
    }

    public boolean isNullSeperateMultipleValues() {
        return this.isNullSeperateMultipleValues;
    }

    public void setNullSeperateMultipleValues(boolean nullSeperateMultipleValues) {
        this.isNullSeperateMultipleValues = nullSeperateMultipleValues;
    }

    private ByteBuffer writeString(CharsetEncoder encoder, String next, int i, int noOfValues) throws CharacterCodingException {
        ByteBuffer bb = i + 1 == noOfValues ? encoder.encode(CharBuffer.wrap(next)) : (this.isNullSeperateMultipleValues() ? encoder.encode(CharBuffer.wrap(next + '\u0000')) : encoder.encode(CharBuffer.wrap(next)));
        bb.rewind();
        return bb;
    }

    private ByteBuffer writeStringUTF16LEBOM(String next, int i, int noOfValues) throws CharacterCodingException {
        CharsetEncoder encoder = Charset.forName("UTF-16LE").newEncoder();
        ByteBuffer bb = null;
        bb = i + 1 == noOfValues ? encoder.encode(CharBuffer.wrap('\ufeff' + next)) : (this.isNullSeperateMultipleValues() ? encoder.encode(CharBuffer.wrap('\ufeff' + next + '\u0000')) : encoder.encode(CharBuffer.wrap('\ufeff' + next)));
        bb.rewind();
        return bb;
    }

    private ByteBuffer writeStringUTF16BEBOM(String next, int i, int noOfValues) throws CharacterCodingException {
        CharsetEncoder encoder = Charset.forName("UTF-16BE").newEncoder();
        ByteBuffer bb = null;
        bb = i + 1 == noOfValues ? encoder.encode(CharBuffer.wrap('\ufeff' + next)) : (this.isNullSeperateMultipleValues() ? encoder.encode(CharBuffer.wrap('\ufeff' + next + '\u0000')) : encoder.encode(CharBuffer.wrap('\ufeff' + next)));
        bb.rewind();
        return bb;
    }

    @Override
    public void addValue(String value) {
        if (this.isNullSeperateMultipleValues()) {
            this.setValue(this.value + "\u0000" + value);
        } else {
            this.setValue(this.value + value);
        }
    }

    @Override
    public int getNumberOfValues() {
        return this.getValues().size();
    }

    @Override
    public String getValueAtIndex(int index) {
        System.out.println("GetValueAtIndex");
        List<String> values = this.getValues();
        return values.get(index);
    }

    public static List<String> splitV23(String value) {
        String[] valuesarray = value.replaceAll("(\\(\\d+\\)|\\(RX\\)|\\(CR\\)\\w*)", "$1\u0000").split("\u0000");
        List<String> values = Arrays.asList(valuesarray);
        if (values.size() == 0) {
            values = new ArrayList<String>(1);
            values.add("");
        }
        return values;
    }

    @Override
    public List<String> getValues() {
        if (this.isNullSeperateMultipleValues()) {
            return TCONString.splitByNullSeperator((String)this.value);
        }
        return TCONString.splitV23((String)this.value);
    }

    @Override
    public String getValueWithoutTrailingNull() {
        List<String> values = this.getValues();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            if (i != 0) {
                sb.append("\u0000");
            }
            sb.append(values.get(i));
        }
        return sb.toString();
    }
}

